using System;
using Server;

namespace Xanthos.Evo
{
	public sealed class RaelisDragonSpec : BaseEvoSpec
	{
		// This class implements a singleton pattern; meaning that no matter how many times the
		// Instance attribute is used, there will only ever be one of these created in the entire system.
		// Copy this template and give it a new name.  Assign all of the data members of the EvoSpec
		// base class in the constructor.  Your subclass must not be abstract.
		// Never call new on this class, use the Instance attribute to get the instance instead.

		RaelisDragonSpec()
		{
			m_Tamable = true;
			m_MinTamingToHatch = 70.0;
			m_PercentFemaleChance = 0.02;	// Made small to limit access to eggs.
			m_GuardianEggOrDeedChance = 0.30;
			m_AlwaysHappy = true;
			m_ProducesYoung = true;
			m_PregnancyTerm = 0.10;
			m_AbsoluteStatValues = false;
			m_MaxEvoResistance = 100;
			m_MaxTrainingStage = 3;
			m_CanAttackPlayers = false;

			m_RandomHues = new int[] { 2101, 2102, 2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 2130, 1281, 1283, 1285, 1378, 1369, 1266 };

			m_Skills = new SkillName[9] { SkillName.Magery, SkillName.EvalInt, SkillName.Meditation, SkillName.MagicResist,
										  SkillName.Tactics, SkillName.Wrestling, SkillName.Anatomy, SkillName.AnimalLore, SkillName.Veterinary };
			m_MinSkillValues = new int[9] { 40, 40, 40, 20, 20, 20, 20, 30, 30 };
			m_MaxSkillValues = new int[9] { 100, 100, 100, 100, 100, 100, 100, 100, 100 };

			m_Stages = new BaseEvoStage[] { new RaelisDragonStageOne(), new RaelisDragonStageTwo(),
											  new RaelisDragonStageThree(), new RaelisDragonStageFour(),
											  new RaelisDragonStageFive(), new RaelisDragonStageSix(),
											  new RaelisDragonStageSeven() };
		}

		// These next 2 lines facilitate the singleton pattern.  In your subclass only change the
		// BaseEvoSpec class name to your subclass of BaseEvoSpec class name and uncomment both lines.
		public static RaelisDragonSpec Instance { get { return Nested.instance; } }
		class Nested { static Nested() { } internal static readonly RaelisDragonSpec instance = new RaelisDragonSpec();}
	}	

	// Define a subclass of BaseEvoStage for each stage in your creature and place them in the
	// array in your subclass of BaseEvoSpec.  See the example classes for how to do this.
	// Your subclass must not be abstract.

	public class RaelisDragonStageOne : BaseEvoStage
	{
		public RaelisDragonStageOne()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 25000; EpMinDivisor = 40; EpMaxDivisor = 30; DustMultiplier = 20;
			BaseSoundID = 0xDB;
			BodyValue = 52; ControlSlots = 3; MinTameSkill = 70.0; VirtualArmor = 30;
			Hue = Evo.Flags.kRandomHueFlag;

			DamagesTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinDamages = new int[1] { 100 };
			MaxDamages = new int[1] { 100 };

			ResistanceTypes = new ResistanceType[1] { ResistanceType.Physical };
			MinResistances = new int[1] { 15 };
			MaxResistances = new int[1] { 15 };

			DamageMin = 13; DamageMax = 17; HitsMin = 150; HitsMax = 160;
			StrMin = 296; StrMax = 325; DexMin = 56; DexMax = 75; IntMin = 76; IntMax = 96;
		}
	}

	public class RaelisDragonStageTwo : BaseEvoStage
	{
		public RaelisDragonStageTwo()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 75000; EpMinDivisor = 100; EpMaxDivisor = 80; DustMultiplier = 20;
			BaseSoundID = 219; MinTameSkill = 80.0;
			BodyValue = 89; VirtualArmor = 40;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 100, 25, 25, 25, 25 };
			MaxDamages = new int[5] { 100, 25, 25, 25, 25 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 20, 20, 20, 20, 20 };
			MaxResistances = new int[5] { 20, 20, 20, 20, 20 };

			DamageMin = 1; DamageMax = 1; HitsMin= 200; HitsMax = 220;
			StrMin = 200; StrMax = 200; DexMin = 20; DexMax = 20; IntMin = 30; IntMax = 30;
		}
	}

	public class RaelisDragonStageThree : BaseEvoStage
	{
		public RaelisDragonStageThree()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 175000; EpMinDivisor = 500; EpMaxDivisor = 300; DustMultiplier = 20;
			BaseSoundID = 0x5A; MinTameSkill = 90.0;
			BodyValue = 0xCE; VirtualArmor = 50;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 40, 40, 40, 40, 40 };
			MaxResistances = new int[5] { 40, 40, 40, 40, 40 };

			DamageMin = 1; DamageMax = 2; HitsMin= 200; HitsMax = 250;
			StrMin = 100; StrMax = 100; DexMin = 30; DexMax = 30; IntMin = 20; IntMax = 20;
		}
	}

	public class RaelisDragonStageFour : BaseEvoStage
	{
		public RaelisDragonStageFour()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 3750000; EpMinDivisor = 550; EpMaxDivisor = 450; DustMultiplier = 20;
			BaseSoundID = 362;
			BodyValue = 60; ControlSlots = 4; MinTameSkill = 100.0; VirtualArmor = 60;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 60, 60, 60, 60, 60 };
			MaxResistances = new int[5] { 60, 60, 60, 60, 60 };	

			DamageMin = 3; DamageMax = 4; HitsMin= 200; HitsMax = 250;
			StrMin = 100; StrMax = 100; DexMin = 50; DexMax = 50; IntMin = 120; IntMax = 120;
		}
	}

	public class RaelisDragonStageFive : BaseEvoStage
	{
		public RaelisDragonStageFive()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 7750000; EpMinDivisor = 900; EpMaxDivisor = 700; DustMultiplier = 20;
			BodyValue = 59; VirtualArmor = 70; MinTameSkill = 110.0;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													 ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 100, 50, 50, 50, 50 };
			MaxDamages = new int[5] { 100, 50, 50, 50, 50 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 70, 70, 70, 70, 70 };
			MaxResistances = new int[5] { 70, 70, 70, 70, 70 };	

			DamageMin = 4; DamageMax = 5; HitsMin= 200; HitsMax = 250;
			StrMin = 100; StrMax = 100; DexMin = 80; DexMax = 80; IntMin = 120; IntMax = 120;
		}
	}

	public class RaelisDragonStageSix : BaseEvoStage
	{
		public RaelisDragonStageSix()
		{
			EvolutionMessage = "has evolved";
			NextEpThreshold = 15000000; EpMinDivisor = 2000; EpMaxDivisor = 1500; DustMultiplier = 20;
			BodyValue = 46; VirtualArmor = 190; MinTameSkill = 115.0;
		
			DamagesTypes = null;
			MinDamages = null;
			MaxDamages = null;

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 80, 80, 80, 80, 80 };
			MaxResistances = new int[5] { 80, 80, 80, 80, 80 };	

			DamageMin = 8; DamageMax = 9; HitsMin= 250; HitsMax = 250;
			StrMin = 100; StrMax = 100; DexMin = 100; DexMax = 100; IntMin = 120; IntMax = 120;
		}
	}

	public class RaelisDragonStageSeven : BaseEvoStage
	{
		public RaelisDragonStageSeven()
		{
			Title = "The Ancient Dragon";
			EvolutionMessage = "has evolved to its highest form and is now an Ancient Dragon";
			NextEpThreshold = 0; EpMinDivisor = 150000; EpMaxDivisor = 100000; DustMultiplier = 20;
			BaseSoundID = 362; MinTameSkill = 120.0;
			BodyValue = 103; ControlSlots = 4; VirtualArmor = 270;
		
			DamagesTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
													 ResistanceType.Poison, ResistanceType.Energy };
			MinDamages = new int[5] { 100, 75, 75, 75, 75 };
			MaxDamages = new int[5] { 100, 75, 75, 75, 75 };

			ResistanceTypes = new ResistanceType[5] { ResistanceType.Physical, ResistanceType.Fire, ResistanceType.Cold,
														ResistanceType.Poison, ResistanceType.Energy };
			MinResistances = new int[5] { 90, 90, 90, 90, 90 };
			MaxResistances = new int[5] { 90, 90, 90, 90, 90 };	

			DamageMin = 6; DamageMax = 7; HitsMin= 250; HitsMax = 250;
			StrMin = 125; StrMax = 125; DexMin = 125; DexMax = 125; IntMin = 125; IntMax = 125;
		}
	}
}